/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.regression;

import ikor.math.Vector;
import ikor.math.regression.Regression;
import ikor.math.regression.RegressionModel;

public abstract class GradientDescentRegression
extends Regression {
    public static final double DEFAULT_LEARNING_RATE = 0.05;
    public static final int DEFAULT_MAX_ITERATIONS = 1000;
    public static final double DEFAULT_MIN_COST_IMPROVEMENT = 1.0E-9;
    private double alpha = 0.05;
    private int maxIterations = 1000;
    private double minCostImprovement = 1.0E-9;
    private RegressionModel model;
    private double[] J;

    public GradientDescentRegression(Vector[] x, Vector y) {
        super(x, y);
    }

    public GradientDescentRegression(double[][] x, double[] y) {
        super(x, y);
    }

    public abstract RegressionModel createModel();

    public RegressionModel getModel() {
        return this.model;
    }

    public void setLearningRate(double alpha) {
        this.alpha = alpha;
    }

    public double getLearningRate() {
        return this.alpha;
    }

    public void setMaxIterations(int iterations) {
        this.maxIterations = iterations;
    }

    public double getMaxIterations() {
        return this.maxIterations;
    }

    public void setMinCostImprovement(double error) {
        this.minCostImprovement = error;
    }

    public double getMinCostImprovement() {
        return this.minCostImprovement;
    }

    public double[] getJ() {
        return this.J;
    }

    public boolean hasConverged(int iteration) {
        return iteration > 1 && Math.abs(this.J[iteration - 1] - this.J[iteration - 2]) < this.minCostImprovement;
    }

    public abstract double cost();

    public abstract double[] gradient();

    public void updateParameters() {
        RegressionModel model = this.getModel();
        double[] t = new double[model.parameters()];
        double[] gradient = this.gradient();
        int j = 0;
        while (j < t.length) {
            t[j] = model.getParameter(j) - this.getLearningRate() * gradient[j];
            ++j;
        }
        model.setParameters(t);
    }

    @Override
    public RegressionModel call() {
        this.model = this.createModel();
        this.J = new double[this.maxIterations];
        int i = 0;
        while (i < this.maxIterations && !this.hasConverged(i)) {
            this.updateParameters();
            this.J[i] = this.cost();
            ++i;
        }
        this.fit(this.model);
        return this.model;
    }
}

