/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.regression;

import ikor.math.Matrix;
import ikor.math.MatrixFactory;
import ikor.math.Vector;
import ikor.math.regression.LinearRegressionModel;
import ikor.math.regression.Regression;

public class LeastSquaresLinearRegression
extends Regression {
    public LeastSquaresLinearRegression(Vector[] x, Vector y) {
        super(x, y);
    }

    public LeastSquaresLinearRegression(double[][] x, double[] y) {
        super(x, y);
    }

    @Override
    public LinearRegressionModel call() {
        int p = this.variables() + 1;
        int m = this.instances();
        Matrix X = MatrixFactory.create(m, p);
        Vector Y = this.getY();
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < p) {
                X.set(i, j, this.getX(j, i));
                ++j;
            }
            ++i;
        }
        Matrix Xt = X.transpose();
        Matrix Yt = ((Matrix)Y).transpose();
        Matrix XtXi = Xt.multiply(X).inverse();
        Matrix result = XtXi.multiply(Xt).multiply(Yt);
        LinearRegressionModel model = new LinearRegressionModel(this.variables());
        int i2 = 0;
        while (i2 < p) {
            model.setParameter(i2, result.get(i2, 0));
            ++i2;
        }
        this.fit(model);
        this.estimateStandardErrors(model, XtXi);
        return model;
    }

    private void estimateStandardErrors(LinearRegressionModel model, Matrix XtXi) {
        int p = this.variables() + 1;
        int m = this.instances();
        double sigma2 = this.getSSE(model) / (double)(m - p);
        Vector parameterErrors = XtXi.getDiagonal();
        int i = 0;
        while (i < p) {
            parameterErrors.set(i, Math.sqrt(sigma2 * parameterErrors.get(i)));
            ++i;
        }
        model.setStandardErrors(parameterErrors);
    }
}

