/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.regression;

import ikor.math.Matrix;
import ikor.math.MatrixFactory;
import ikor.math.Vector;
import ikor.math.regression.LinearRegressionModel;
import ikor.math.regression.Regression;

public class LeastSquaresRegularizedLinearRegression
extends Regression {
    private double lambda;

    public LeastSquaresRegularizedLinearRegression(Vector[] x, Vector y) {
        super(x, y);
    }

    public LeastSquaresRegularizedLinearRegression(double[][] x, double[] y) {
        super(x, y);
    }

    public double getRegularizationFactor() {
        return this.lambda;
    }

    public void setRegularizationFactor(double lambda) {
        this.lambda = lambda;
    }

    @Override
    public LinearRegressionModel call() {
        int p = this.variables() + 1;
        int m = this.instances();
        Matrix X = MatrixFactory.create(m, p);
        Vector Y = this.getY();
        Matrix regularization = MatrixFactory.create(p, p);
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < p) {
                X.set(i, j, this.getX(j, i));
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i < p) {
            regularization.set(i, i, this.lambda);
            ++i;
        }
        Matrix Xt = X.transpose();
        Matrix Yt = ((Matrix)Y).transpose();
        Matrix XtXri = Xt.multiply(X).add(regularization).inverse();
        Matrix result = XtXri.multiply(Xt).multiply(Yt);
        LinearRegressionModel model = new LinearRegressionModel(this.variables());
        int i2 = 0;
        while (i2 < p) {
            model.setParameter(i2, result.get(i2, 0));
            ++i2;
        }
        this.fit(model);
        return model;
    }
}

