/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.regression;

import ikor.math.regression.RegressionModel;
import ikor.math.statistics.FDistribution;
import ikor.math.statistics.StudentTDistribution;

public class LinearRegressionModel
extends RegressionModel {
    public LinearRegressionModel(int variables) {
        super(variables);
    }

    public LinearRegressionModel(double[] coefficients) {
        super(coefficients);
    }

    public double FStatistic() {
        return this.ssr() / (double)(this.parameters() - 1) / ((this.sst() - this.ssr()) / (double)(this.n() - this.parameters()));
    }

    public double pValueF() {
        FDistribution fdist = new FDistribution(this.parameters() - 1, this.n() - this.parameters());
        return 1.0 - fdist.cdf(this.FStatistic());
    }

    @Override
    public double pValue(int p) {
        double t = this.tStatistic(p);
        StudentTDistribution tdist = new StudentTDistribution(this.dof());
        return 2.0 * Math.min(tdist.cdf(t), 1.0 - tdist.cdf(t));
    }

    public double logLikelihood() {
        return (double)(-this.n()) / 2.0 * (Math.log(Math.PI * 2 / (double)this.n()) + Math.log(this.sse()) + 1.0);
    }

    public double AIC() {
        int k = this.parameters();
        return ((double)(2 * k) - 2.0 * this.logLikelihood()) / (double)this.n();
    }

    public double AICc() {
        double k = this.parameters();
        return this.AIC() + 2.0 * k * (k + 1.0) / ((double)this.n() - k - 1.0);
    }

    public double BIC() {
        int k = this.parameters();
        return ((double)k * Math.log(this.n()) - 2.0 * this.logLikelihood()) / (double)this.n();
    }

    @Override
    public double predict(double[] x) {
        double h = this.getParameter(0);
        int j = 0;
        while (j < x.length) {
            h += x[j] * this.getParameter(j + 1);
            ++j;
        }
        return h;
    }
}

