/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.regression;

import ikor.math.regression.RegressionModel;
import ikor.math.statistics.NormalDistribution;

public class LogisticRegressionModel
extends RegressionModel {
    public LogisticRegressionModel(int variables) {
        super(variables);
    }

    public LogisticRegressionModel(double[] coefficients) {
        super(coefficients);
    }

    @Override
    public double predict(double[] x) {
        double h = this.getParameter(0);
        int j = 0;
        while (j < x.length) {
            h += x[j] * this.getParameter(j + 1);
            ++j;
        }
        return 1.0 / (1.0 + Math.exp(-h));
    }

    public double waldStatistic(int p) {
        double beta = this.getParameter(p);
        double stderr = this.standardError(p);
        return beta * beta / (stderr * stderr);
    }

    @Override
    public double pValue(int p) {
        double t = this.tStatistic(p);
        NormalDistribution norm = new NormalDistribution(0.0, 1.0);
        return 2.0 * norm.cdf(-Math.abs(t));
    }
}

