/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.regression;

import ikor.math.Matrix;
import ikor.math.MatrixFactory;
import ikor.math.Vector;
import ikor.math.regression.GradientDescentLogisticRegression;
import ikor.math.regression.RegressionModel;

public class NewtonMethodLogisticRegression
extends GradientDescentLogisticRegression {
    public static final double DEFAULT_STEP_SIZE = 1.0;

    public NewtonMethodLogisticRegression(double[][] x, double[] y) {
        super(x, y);
        this.setLearningRate(1.0);
    }

    public NewtonMethodLogisticRegression(Vector[] x, Vector y) {
        super(x, y);
        this.setLearningRate(1.0);
    }

    @Override
    public void updateParameters() {
        RegressionModel model = this.getModel();
        double[] t = new double[model.parameters()];
        Vector grad = MatrixFactory.createVector(this.gradient()).transpose();
        Matrix hessian = MatrixFactory.create(this.hessian());
        Matrix update = hessian.inverse().multiply(grad);
        int j = 0;
        while (j < t.length) {
            t[j] = model.getParameter(j) - this.getLearningRate() * update.get(j, 0);
            ++j;
        }
        model.setParameters(t);
    }

    @Override
    public void fit(RegressionModel model) {
        super.fit(model);
        Vector variance = this.covariance().getDiagonal();
        Vector stderr = MatrixFactory.createVector(variance);
        int i = 0;
        while (i < stderr.size()) {
            stderr.set(i, Math.sqrt(stderr.get(i)));
            ++i;
        }
        model.setStandardErrors(stderr);
    }
}

