/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.regression;

import ikor.math.Matrix;
import ikor.math.MatrixFactory;
import ikor.math.Vector;
import ikor.math.regression.RegressionModel;
import ikor.parallel.Task;

public abstract class Regression
extends Task<RegressionModel> {
    Vector[] x;
    Vector y;

    public Regression(Vector[] x, Vector y) {
        this.x = x;
        this.y = y;
    }

    public Regression(Matrix x, Vector y) {
        this.y = y;
        this.x = new Vector[x.columns()];
        int i = 0;
        while (i < x.columns()) {
            this.x[i] = x.getColumn(i);
            ++i;
        }
    }

    public Regression(double[][] x, double[] y) {
        this.x = new Vector[x.length];
        int i = 0;
        while (i < x.length) {
            this.x[i] = MatrixFactory.createVector(x[i]);
            ++i;
        }
        this.y = MatrixFactory.createVector(y);
    }

    public int variables() {
        return this.x.length;
    }

    public int instances() {
        return this.y.size();
    }

    public Vector[] getX() {
        return this.x;
    }

    public Vector getX(int j) {
        return this.x[j - 1];
    }

    public double getX(int j, int i) {
        if (j > 0) {
            return this.x[j - 1].get(i);
        }
        return 1.0;
    }

    public Vector getY() {
        return this.y;
    }

    public double getY(int i) {
        return this.y.get(i);
    }

    public void fit(RegressionModel model) {
        model.setN(this.instances());
        model.setSSE(this.getSSE(model));
        model.setSST(this.getSST(model));
        model.setDW(this.getDW(model));
    }

    public double getSST(RegressionModel model) {
        int m = this.y.size();
        double mean = this.y.average();
        double sst = 0.0;
        int i = 0;
        while (i < m) {
            double d = this.getY(i) - mean;
            sst += d * d;
            ++i;
        }
        return sst;
    }

    public double getSSR(RegressionModel model) {
        int m = this.y.size();
        double mean = this.y.average();
        double ssr = 0.0;
        int i = 0;
        while (i < m) {
            double d = this.getPrediction(model, i) - mean;
            ssr += d * d;
            ++i;
        }
        return ssr;
    }

    public double getSSE(RegressionModel model) {
        int m = this.y.size();
        double sse = 0.0;
        int i = 0;
        while (i < m) {
            double d = this.getResidual(model, i);
            sse += d * d;
            ++i;
        }
        return sse;
    }

    public double getDW(RegressionModel model) {
        int m = this.y.size();
        double sum = 0.0;
        int i = 1;
        while (i < m) {
            double d = this.getResidual(model, i) - this.getResidual(model, i - 1);
            sum += d * d;
            ++i;
        }
        return sum / this.getSSE(model);
    }

    public double getResidual(RegressionModel model, int i) {
        return this.getPrediction(model, i) - this.getY(i);
    }

    public double getPrediction(RegressionModel model, int i) {
        double[] d = new double[this.variables()];
        int j = 0;
        while (j < this.variables()) {
            d[j] = this.x[j].get(i);
            ++j;
        }
        return model.predict(d);
    }

    @Override
    public abstract RegressionModel call();
}

