/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.regression;

import ikor.math.MatrixFactory;
import ikor.math.Vector;

public abstract class RegressionModel {
    private Vector parameters;
    private int n;
    private double sse;
    private double sst;
    private Vector standardErrors;
    private double dw;

    public RegressionModel(int variables) {
        this.parameters = MatrixFactory.createVector(variables + 1);
    }

    public RegressionModel(double[] coefficients) {
        this.parameters = MatrixFactory.createVector(coefficients.length);
        int i = 0;
        while (i < coefficients.length) {
            this.setParameter(i, coefficients[i]);
            ++i;
        }
    }

    public int parameters() {
        return this.parameters.size();
    }

    public double getParameter(int i) {
        return this.parameters.get(i);
    }

    public void setParameter(int i, double value) {
        this.parameters.set(i, value);
    }

    public void setParameters(Vector parameters) {
        this.parameters = parameters;
    }

    public void setParameters(double[] values) {
        int i = 0;
        while (i < values.length) {
            this.setParameter(i, values[i]);
            ++i;
        }
    }

    public int n() {
        return this.n;
    }

    public void setN(int n) {
        this.n = n;
    }

    public double sse() {
        return this.sse;
    }

    public void setSSE(double sse) {
        this.sse = sse;
    }

    public double sst() {
        return this.sst;
    }

    public void setSST(double sst) {
        this.sst = sst;
    }

    public double ssr() {
        return this.sst - this.sse;
    }

    public double R2() {
        return 1.0 - this.sse / this.sst;
    }

    public double adjustedR2() {
        return 1.0 - (double)(this.n - 1) * (1.0 - this.R2()) / (double)(this.n - this.parameters());
    }

    public double rmse() {
        return Math.sqrt(this.sse / (double)(this.n - this.parameters()));
    }

    public double explainedVariance() {
        return this.ssr() / this.sst();
    }

    public void setStandardErrors(Vector errors) {
        this.standardErrors = errors;
    }

    public double standardError(int p) {
        if (this.standardErrors != null) {
            return this.standardErrors.get(p);
        }
        return Double.NaN;
    }

    public int dof() {
        return this.n() - this.parameters();
    }

    public double tStatistic(int p) {
        return this.getParameter(p) / this.standardError(p);
    }

    public abstract double pValue(int var1);

    protected void setDW(double dw) {
        this.dw = dw;
    }

    public double DurbinWatsonStatistic() {
        return this.dw;
    }

    public abstract double predict(double[] var1);
}

