/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics;

import ikor.math.Functions;
import ikor.math.statistics.Distribution;
import ikor.math.statistics.GammaDistribution;

public class BetaDistribution
implements Distribution {
    private double alpha;
    private double beta;
    private double factor;
    GammaDistribution gammaAlpha = null;
    GammaDistribution gammaBeta = null;

    public BetaDistribution(double alpha, double beta) {
        this.alpha = alpha;
        this.beta = beta;
        this.factor = -Functions.logBeta(alpha, beta);
    }

    @Override
    public double pdf(double x) {
        if (x <= 0.0 || x >= 1.0) {
            return 0.0;
        }
        return Math.exp((this.alpha - 1.0) * Math.log(x) + (this.beta - 1.0) * Math.log(1.0 - x) + this.factor);
    }

    @Override
    public double cdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= 1.0) {
            return 1.0;
        }
        return Functions.betaI(this.alpha, this.beta, x);
    }

    @Override
    public double idf(double p) {
        if (p == 0.0) {
            return 0.0;
        }
        if (p == 1.0) {
            return 1.0;
        }
        return Functions.betaIinv(p, this.alpha, this.beta);
    }

    @Override
    public double random() {
        if (this.gammaAlpha == null) {
            this.gammaAlpha = new GammaDistribution(this.alpha, 1.0);
        }
        if (this.gammaBeta == null) {
            this.gammaBeta = new GammaDistribution(this.beta, 1.0);
        }
        double x = this.gammaAlpha.random();
        double y = this.gammaBeta.random();
        return x / (x + y);
    }

    @Override
    public double mean() {
        return this.alpha / (this.alpha + this.beta);
    }

    @Override
    public double variance() {
        return this.alpha * this.beta / ((this.alpha + this.beta) * (this.alpha + this.beta) * (this.alpha + this.beta + 1.0));
    }

    @Override
    public double skewness() {
        return 2.0 * (this.beta - this.alpha) * Math.sqrt(this.alpha + this.beta + 1.0) / ((this.alpha + this.beta + 2.0) * Math.sqrt(this.alpha * this.beta));
    }

    @Override
    public double kurtosis() {
        return 6.0 * ((this.alpha - this.beta) * (this.alpha - this.beta) * (this.alpha + this.beta + 1.0) - this.alpha * this.beta * (this.alpha + this.beta + 2.0)) / (this.alpha * this.beta * (this.alpha + this.beta + 2.0) * (this.alpha + this.beta + 3.0));
    }
}

