/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics;

import ikor.math.Functions;
import ikor.math.random.Random;
import ikor.math.statistics.BetaDistribution;
import ikor.math.statistics.DiscreteDistribution;
import ikor.math.statistics.Distribution;

public class BinomialDistribution
extends DiscreteDistribution
implements Distribution {
    private int n;
    private double p;

    public BinomialDistribution(int n, double p) {
        this.n = n;
        this.p = p;
    }

    @Override
    public double pdf(double x) {
        int k = (int)x;
        if (k < 0 || k > this.n) {
            return 0.0;
        }
        return Math.exp((double)k * Math.log(this.p) + (double)(this.n - k) * Math.log(1.0 - this.p) + Functions.logBinomial(this.n, k));
    }

    @Override
    public double cdf(double x) {
        int k = (int)x;
        if (k <= 0) {
            return 0.0;
        }
        if (k >= this.n) {
            return 1.0;
        }
        return 1.0 - Functions.betaI(k, this.n - k + 1, this.p);
    }

    @Override
    public double idf(double p) {
        if (p == 0.0) {
            return 0.0;
        }
        if (p == 1.0) {
            return this.n;
        }
        int k = Math.max(0, Math.min(this.n, (int)((double)this.n * p)));
        return this.idfsearch(p, k, 0, this.n + 1);
    }

    @Override
    public double random() {
        int i;
        int x = 0;
        int pivot = (int)((double)this.n * this.p);
        do {
            BetaDistribution beta;
            double v;
            if (this.p < (v = (beta = new BetaDistribution(i = (int)(1.0 + (double)this.n * this.p), (double)this.n + 1.0 - (double)i)).random())) {
                this.p /= v;
                this.n = i - 1;
                continue;
            }
            x += i;
            this.p = (this.p - v) / (1.0 - v);
            this.n -= i;
        } while (this.n > pivot);
        i = 0;
        while (i < pivot) {
            double u = Random.random();
            if (u < this.p) {
                ++x;
            }
            ++i;
        }
        return x;
    }

    @Override
    public double mean() {
        return (double)this.n * this.p;
    }

    @Override
    public double variance() {
        return (double)this.n * this.p * (1.0 - this.p);
    }

    @Override
    public double skewness() {
        return (1.0 - 2.0 * this.p) / Math.sqrt((double)this.n * this.p * (1.0 - this.p));
    }

    @Override
    public double kurtosis() {
        return (1.0 - 6.0 * this.p * (1.0 - this.p)) / ((double)this.n * this.p * (1.0 - this.p));
    }
}

