/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics;

import ikor.math.random.Random;
import ikor.math.statistics.Distribution;

public class CauchyDistribution
implements Distribution {
    private double mu;
    private double sigma;

    public CauchyDistribution(double center, double width) {
        this.mu = center;
        this.sigma = width;
    }

    @Override
    public double pdf(double x) {
        double z = (x - this.mu) / this.sigma;
        return 1.0 / (Math.PI * this.sigma * (1.0 + z * z));
    }

    @Override
    public double cdf(double x) {
        return 0.5 + Math.atan2(x - this.mu, this.sigma) / Math.PI;
    }

    @Override
    public double idf(double p) {
        if (p == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.mu + this.sigma * Math.tan(Math.PI * (p - 0.5));
    }

    @Override
    public double random() {
        double v2;
        double v1;
        while ((v1 = 2.0 * Random.random() - 1.0) * v1 + (v2 = Random.random()) * v2 >= 1.0 || v2 == 0.0) {
        }
        return this.mu + this.sigma * v1 / v2;
    }

    @Override
    public double mean() {
        return Double.NaN;
    }

    @Override
    public double variance() {
        return Double.NaN;
    }

    @Override
    public double skewness() {
        return Double.NaN;
    }

    @Override
    public double kurtosis() {
        return Double.NaN;
    }
}

