/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics;

import ikor.math.Functions;
import ikor.math.statistics.Distribution;
import ikor.math.statistics.GammaDistribution;

public class ChiSquaredDistribution
implements Distribution {
    private double k;
    private double f;
    private GammaDistribution gamma = null;

    public ChiSquaredDistribution(double degrees) {
        this.k = degrees;
        this.f = Math.log(2.0) * 0.5 * this.k + Functions.logGamma(0.5 * this.k);
    }

    @Override
    public double pdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return Math.exp(-0.5 * (x - (this.k - 2.0) * Math.log(x)) - this.f);
    }

    @Override
    public double cdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return Functions.gammaP(0.5 * this.k, 0.5 * x);
    }

    public double pvalue(double x) {
        return 1.0 - this.cdf(x);
    }

    @Override
    public double idf(double p) {
        if (p == 0.0) {
            return 0.0;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return 2.0 * Functions.gammaPinv(p, 0.5 * this.k);
    }

    @Override
    public double random() {
        if (this.gamma == null) {
            this.gamma = new GammaDistribution(0.5 * this.k, 1.0);
        }
        return 2.0 * this.gamma.random();
    }

    @Override
    public double mean() {
        return this.k;
    }

    @Override
    public double variance() {
        return 2.0 * this.k;
    }

    @Override
    public double skewness() {
        return Math.sqrt(8.0 / this.k);
    }

    @Override
    public double kurtosis() {
        return 12.0 / this.k;
    }
}

