/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics;

import ikor.math.random.Random;
import ikor.math.statistics.DiscreteDistribution;

public class DiscreteProbabilityDistribution
extends DiscreteDistribution {
    private int size;
    private double[] values;
    private double[] probabilities;
    private double sumProbabilities;
    private static final double EPSILON = 1.0E-9;

    public DiscreteProbabilityDistribution() {
        this.size = 0;
        this.values = new double[0];
        this.probabilities = new double[0];
    }

    public DiscreteProbabilityDistribution(double[] values, double[] probabilities) {
        if (values.length != probabilities.length) {
            throw new RuntimeException("Value and probabilitiy arrays should be of the same size");
        }
        boolean sorted = true;
        int i = 0;
        while (i < this.size - 1) {
            if (values[i] >= values[i + 1]) {
                sorted = false;
            }
            ++i;
        }
        if (!sorted) {
            throw new RuntimeException("Values should be sorted in the given array");
        }
        this.size = values.length;
        this.values = new double[this.size];
        this.probabilities = new double[this.size];
        this.sumProbabilities = 0.0;
        i = 0;
        while (i < this.size) {
            this.values[i] = values[i];
            this.probabilities[i] = probabilities[i];
            this.sumProbabilities += probabilities[i];
            ++i;
        }
    }

    public void add(double value, double probability) {
        int pos = 0;
        while (pos < this.size && this.values[pos] < value) {
            ++pos;
        }
        double[] newValues = new double[this.size + 1];
        double[] newProbabilities = new double[this.size + 1];
        int i = 0;
        while (i < pos) {
            newValues[i] = this.values[i];
            newProbabilities[i] = this.probabilities[i];
            ++i;
        }
        newValues[pos] = value;
        newProbabilities[pos] = probability;
        i = pos;
        while (i < this.size) {
            newValues[i + 1] = this.values[i];
            newProbabilities[i + 1] = this.probabilities[i];
            ++i;
        }
        ++this.size;
        this.values = newValues;
        this.probabilities = newProbabilities;
        this.sumProbabilities += probability;
    }

    public double value(int i) {
        return this.values[i];
    }

    public double probability(int i) {
        return this.probabilities[i] / this.sumProbabilities;
    }

    @Override
    public double pdf(double x) {
        int index = this.indexOf(x);
        if (index == -1) {
            return 0.0;
        }
        return this.probability(index);
    }

    private int indexOf(double value) {
        int low = 0;
        int high = this.values.length - 1;
        while (low <= high) {
            int middle = (low + high) / 2;
            if (value > this.values[middle]) {
                low = middle + 1;
                continue;
            }
            if (value < this.values[middle]) {
                high = middle - 1;
                continue;
            }
            return middle;
        }
        return -1;
    }

    @Override
    public double cdf(double x) {
        double cdfValue = 0.0;
        int i = 0;
        while (i < this.size && this.values[i] <= x) {
            cdfValue += this.probability(i);
            ++i;
        }
        return cdfValue;
    }

    @Override
    public double idf(double p) {
        double cdf = 0.0;
        int i = 0;
        while (i < this.size - 1) {
            if (Math.abs(p - (cdf += this.probability(i))) < 1.0E-9) {
                return this.values[i + 1];
            }
            if (cdf > p) {
                return this.values[i];
            }
            ++i;
        }
        return this.values[this.size - 1];
    }

    @Override
    public double random() {
        return this.idf(Random.random());
    }

    @Override
    public double mean() {
        double mean = 0.0;
        int i = 0;
        while (i < this.size) {
            mean += this.values[i] * this.probability(i);
            ++i;
        }
        return mean;
    }

    @Override
    public double variance() {
        double variance = 0.0;
        double mean = this.mean();
        int i = 0;
        while (i < this.size) {
            variance += this.probability(i) * (this.values[i] - mean) * (this.values[i] - mean);
            ++i;
        }
        return variance;
    }

    @Override
    public double skewness() {
        double skewness = 0.0;
        double mean = this.mean();
        int i = 0;
        while (i < this.size) {
            skewness += this.probability(i) * Math.pow(this.values[i] - mean, 3.0);
            ++i;
        }
        return skewness /= Math.pow(this.variance(), 1.5);
    }

    @Override
    public double kurtosis() {
        double kurtosis = 0.0;
        double mean = this.mean();
        int i = 0;
        while (i < this.size) {
            kurtosis += this.probability(i) * Math.pow(this.values[i] - mean, 4.0);
            ++i;
        }
        return kurtosis /= Math.pow(this.variance(), 2.0);
    }
}

