/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics;

import ikor.math.random.Random;
import ikor.math.statistics.DiscreteDistribution;
import ikor.math.statistics.Distribution;

public class DiscreteUniformDistribution
extends DiscreteDistribution
implements Distribution {
    private int a;
    private int b;

    public DiscreteUniformDistribution(int a, int b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public double pdf(double x) {
        int k = (int)x;
        if (k < this.a || k > this.b) {
            return 0.0;
        }
        return 1.0 / ((double)(this.b - this.a) + 1.0);
    }

    @Override
    public double cdf(double x) {
        int k = (int)Math.floor(x);
        if (k < this.a) {
            return 0.0;
        }
        if (k >= this.b) {
            return 1.0;
        }
        return ((double)(k - this.a) + 1.0) / ((double)(this.b - this.a) + 1.0);
    }

    @Override
    public double idf(double p) {
        if (p == 0.0) {
            return this.a - 1;
        }
        if (p == 1.0) {
            return this.b;
        }
        int k = (int)((double)this.a + (double)(this.b - this.a) * p);
        return this.idfsearch(p, k, this.a - 1, this.b + 1);
    }

    @Override
    public double random() {
        double u = Random.random();
        return (int)((double)this.a + u * (double)(this.b - this.a + 1));
    }

    @Override
    public double mean() {
        return (double)(this.a + this.b) / 2.0;
    }

    @Override
    public double variance() {
        double n = this.b - this.a + 1;
        return (n * n - 1.0) / 12.0;
    }

    @Override
    public double skewness() {
        return 0.0;
    }

    @Override
    public double kurtosis() {
        double n = this.b - this.a + 1;
        return -1.2 * (n * n + 1.0) / (n * n - 1.0);
    }
}

