/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics;

import ikor.math.random.Random;
import ikor.math.statistics.Distribution;

public class ExponentialDistribution
implements Distribution {
    private double lambda;

    public ExponentialDistribution(double lambda) {
        this.lambda = lambda;
    }

    @Override
    public double pdf(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return this.lambda * Math.exp(-this.lambda * x);
    }

    @Override
    public double cdf(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return 1.0 - Math.exp(-this.lambda * x);
    }

    @Override
    public double idf(double p) {
        if (p == 0.0) {
            return 0.0;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return -Math.log(1.0 - p) / this.lambda;
    }

    @Override
    public double random() {
        double u;
        while ((u = Random.random()) == 0.0) {
        }
        return -Math.log(u) / this.lambda;
    }

    @Override
    public double mean() {
        return 1.0 / this.lambda;
    }

    @Override
    public double variance() {
        return 1.0 / (this.lambda * this.lambda);
    }

    @Override
    public double skewness() {
        return 2.0;
    }

    @Override
    public double kurtosis() {
        return 6.0;
    }
}

