/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics;

import ikor.math.Functions;
import ikor.math.statistics.BetaDistribution;
import ikor.math.statistics.Distribution;

public class FDistribution
implements Distribution {
    private double d1;
    private double d2;
    private double factor;
    private BetaDistribution beta = null;

    public FDistribution(double d1, double d2) {
        this.d1 = d1;
        this.d2 = d2;
        this.factor = 0.5 * (d1 * Math.log(d1) + d2 * Math.log(d2)) + Functions.logGamma(0.5 * (d1 + d2)) - Functions.logGamma(0.5 * d1) - Functions.logGamma(0.5 * d2);
    }

    @Override
    public double pdf(double f) {
        if (f <= 0.0) {
            return 0.0;
        }
        return Math.exp((0.5 * this.d1 - 1.0) * Math.log(f) - 0.5 * (this.d1 + this.d2) * Math.log(this.d2 + this.d1 * f) + this.factor);
    }

    @Override
    public double cdf(double f) {
        if (f <= 0.0) {
            return 0.0;
        }
        return Functions.betaI(0.5 * this.d1, 0.5 * this.d2, this.d1 * f / (this.d2 + this.d1 * f));
    }

    @Override
    public double idf(double p) {
        if (p == 0.0) {
            return 0.0;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double x = Functions.betaIinv(p, 0.5 * this.d1, 0.5 * this.d2);
        return this.d2 * x / (this.d1 * (1.0 - x));
    }

    @Override
    public double random() {
        if (this.beta == null) {
            this.beta = new BetaDistribution(0.5 * this.d1, 0.5 * this.d2);
        }
        double x = this.beta.random();
        return this.d2 * x / (this.d1 * (1.0 - x));
    }

    @Override
    public double mean() {
        if (this.d2 > 2.0) {
            return this.d2 / (this.d2 - 2.0);
        }
        return Double.NaN;
    }

    @Override
    public double variance() {
        if (this.d2 > 4.0) {
            return 2.0 * this.d2 * this.d2 * (this.d1 + this.d2 - 2.0) / (this.d1 * (this.d2 - 2.0) * (this.d2 - 2.0) * (this.d2 - 4.0));
        }
        return Double.NaN;
    }

    @Override
    public double skewness() {
        if (this.d2 > 6.0) {
            return (2.0 * this.d1 + this.d2 - 2.0) * Math.sqrt(8.0 * (this.d2 - 4.0)) / ((this.d2 - 6.0) * Math.sqrt(this.d1 * (this.d1 + this.d2 - 2.0)));
        }
        return Double.NaN;
    }

    @Override
    public double kurtosis() {
        if (this.d2 > 8.0) {
            return 12.0 * (this.d1 * (5.0 * this.d2 - 22.0) * (this.d1 + this.d2 - 2.0) + (this.d2 - 4.0) * (this.d2 - 2.0) * (this.d2 - 2.0)) / (this.d1 * (this.d2 - 6.0) * (this.d2 - 8.0) * (this.d1 + this.d2 - 2.0));
        }
        return Double.NaN;
    }
}

