/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics;

import ikor.math.Functions;
import ikor.math.random.Random;
import ikor.math.statistics.Distribution;

public class GammaDistribution
implements Distribution {
    private double alpha;
    private double beta;
    private double factor;

    public GammaDistribution(double shape, double rate) {
        this.alpha = shape;
        this.beta = rate;
        this.factor = this.alpha * Math.log(this.beta) - Functions.logGamma(this.alpha);
    }

    @Override
    public double pdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return Math.exp(-this.beta * x + (this.alpha - 1.0) * Math.log(x) + this.factor);
    }

    @Override
    public double cdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return Functions.gammaP(this.alpha, this.beta * x);
    }

    @Override
    public double idf(double p) {
        if (p == 0.0) {
            return 0.0;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return Functions.gammaPinv(p, this.alpha) / this.beta;
    }

    @Override
    public double random() {
        double v;
        double a1 = this.alpha - 0.3333333333333333;
        double a2 = 1.0 / Math.sqrt(9.0 * a1);
        while (true) {
            double x;
            if ((v = 1.0 + a2 * (x = Random.gaussian())) <= 0.0) {
                continue;
            }
            v = v * v * v;
            double u = Random.random();
            if (!(u > 1.0 - 0.331 * x * x * x * x) || !(Math.log(u) > 0.5 * x * x + a1 * (1.0 - v + Math.log(v)))) break;
        }
        return a1 * v / this.beta;
    }

    @Override
    public double mean() {
        return this.alpha / this.beta;
    }

    @Override
    public double variance() {
        return this.alpha / (this.beta * this.beta);
    }

    @Override
    public double skewness() {
        return 2.0 / Math.sqrt(this.alpha);
    }

    @Override
    public double kurtosis() {
        return 6.0 / this.alpha;
    }
}

