/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics;

import ikor.math.random.Random;
import ikor.math.statistics.DiscreteDistribution;
import ikor.math.statistics.Distribution;

public class GeometricDistribution
extends DiscreteDistribution
implements Distribution {
    private double p;

    public GeometricDistribution(double p) {
        this.p = p;
    }

    @Override
    public double pdf(double x) {
        int k = (int)x;
        if (k < 0) {
            return 0.0;
        }
        return this.p * Math.pow(1.0 - this.p, k);
    }

    @Override
    public double cdf(double x) {
        int k = (int)x;
        if (k <= 0) {
            return 0.0;
        }
        if ((double)k == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        return 1.0 - Math.pow(1.0 - this.p, k + 1);
    }

    @Override
    public double idf(double p) {
        if (p == 0.0) {
            return 0.0;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        int k = 1;
        return this.idfsearch(p, k, 0, Integer.MAX_VALUE);
    }

    @Override
    public double random() {
        double u;
        while ((u = Random.random()) == 0.0) {
        }
        return (int)Math.floor(Math.log(u) / Math.log(1.0 - this.p));
    }

    @Override
    public double mean() {
        return (1.0 - this.p) / this.p;
    }

    @Override
    public double variance() {
        return (1.0 - this.p) / (this.p * this.p);
    }

    @Override
    public double skewness() {
        return (2.0 - this.p) / Math.sqrt(1.0 - this.p);
    }

    @Override
    public double kurtosis() {
        return 6.0 + this.p * this.p / (1.0 - this.p);
    }
}

