/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics;

import ikor.math.Constants;
import ikor.math.Functions;
import ikor.math.random.Random;
import ikor.math.statistics.Distribution;

public class HalfNormalDistribution
implements Distribution {
    private double mu;
    private double sigma;

    public HalfNormalDistribution(double location, double scale) {
        this.mu = location;
        this.sigma = scale;
    }

    @Override
    public double pdf(double x) {
        if (x < this.mu) {
            return 0.0;
        }
        return Constants.SQRT2 * Math.exp(-(x - this.mu) * (x - this.mu) / (2.0 * this.sigma * this.sigma)) / (this.sigma * Constants.SQRTPI);
    }

    @Override
    public double cdf(double x) {
        if (x < this.mu) {
            return 0.0;
        }
        return 2.0 * Functions.Phi((x - this.mu) / this.sigma) - 1.0;
    }

    @Override
    public double idf(double p) {
        return this.mu + this.sigma * Functions.probit((1.0 + p) / 2.0);
    }

    @Override
    public double random() {
        double x = this.mu + this.sigma * Random.gaussian();
        return Math.abs(x - this.mu);
    }

    @Override
    public double mean() {
        return this.sigma * Math.sqrt(0.6366197723675814);
    }

    @Override
    public double variance() {
        return this.sigma * this.sigma * 0.3633802276324186;
    }

    @Override
    public double skewness() {
        return Double.NaN;
    }

    @Override
    public double kurtosis() {
        return Double.NaN;
    }
}

