/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics;

import ikor.math.Functions;
import ikor.math.random.Random;
import ikor.math.statistics.DiscreteDistribution;
import ikor.math.statistics.Distribution;

public class HypergeometricDistribution
extends DiscreteDistribution
implements Distribution {
    private int N;
    private int K;
    private int n;

    public HypergeometricDistribution(int N, int K, int n) {
        this.N = N;
        this.K = K;
        this.n = n;
    }

    @Override
    public double pdf(double x) {
        int k = (int)x;
        if (k < 0) {
            return 0.0;
        }
        return Math.exp(Functions.logBinomial(this.K, k) + Functions.logBinomial(this.N - this.K, this.n - k) - Functions.logBinomial(this.N, this.n));
    }

    @Override
    public double cdf(double x) {
        int k = (int)x;
        if (k < 0) {
            return 0.0;
        }
        if (k > Math.min(this.K, this.n)) {
            return 1.0;
        }
        double total = 0.0;
        int i = Math.max(0, this.n + this.K - this.N);
        while (i < k) {
            total += this.pdf(i);
            ++i;
        }
        return total;
    }

    @Override
    public double idf(double p) {
        if (p == 0.0) {
            return 0.0;
        }
        if (p == 1.0) {
            return Math.min(this.K, this.n) + 1;
        }
        int k = 1;
        return this.idfsearch(p, k, 0, Math.min(this.K, this.n) + 1);
    }

    @Override
    public double random() {
        double x = 0.0;
        double g = this.K;
        double h = this.n;
        double t = this.N;
        int i = 1;
        while (i <= this.n && g > 0.0 && h > 0.0) {
            double u = Random.random();
            if (u <= g / t) {
                x += 1.0;
                g -= 1.0;
            } else {
                h -= 1.0;
            }
            if (h == 0.0) {
                x = x + (double)this.n - (double)i;
            }
            t -= 1.0;
            ++i;
        }
        return x;
    }

    @Override
    public double mean() {
        return (double)(this.n * this.K) / (double)this.N;
    }

    @Override
    public double variance() {
        return this.mean() * (double)(this.N - this.K) * (double)(this.N - this.n) / (double)(this.N * (this.N - 1));
    }

    @Override
    public double skewness() {
        return (double)(this.N - 2 * this.K) * Math.sqrt(this.N - 1) * (double)(this.N - 2 * this.n) / ((double)(this.N - 2) * Math.sqrt(this.n * this.K * (this.N - this.K) * (this.N - this.n)));
    }

    @Override
    public double kurtosis() {
        return (((double)this.N - 1.0) * (double)this.N * (double)this.N * ((double)this.N * ((double)this.N + 1.0) - 6.0 * (double)this.K * (double)(this.N - this.K) - 6.0 * (double)this.n * (double)(this.N - this.n)) + 6.0 * (double)this.n * (double)this.K * (double)(this.N - this.K) * (double)(this.N - this.n) * (5.0 * (double)this.N - 6.0)) / ((double)(this.n * this.K * (this.N - this.K) * (this.N - this.n)) * ((double)this.N - 2.0) * ((double)this.N - 3.0));
    }
}

