/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics;

import ikor.math.random.Random;
import ikor.math.statistics.Distribution;
import ikor.math.statistics.ExponentialDistribution;

public class LaplaceDistribution
implements Distribution {
    private double mu;
    private double b;
    private ExponentialDistribution exponential = null;

    public LaplaceDistribution(double location, double scale) {
        this.mu = location;
        this.b = scale;
    }

    @Override
    public double pdf(double x) {
        return 0.5 * Math.exp(-Math.abs(x - this.mu) / this.b) / this.b;
    }

    @Override
    public double cdf(double x) {
        if (x >= this.mu) {
            return 0.5 + 0.5 * (1.0 - Math.exp(-(x - this.mu) / this.b));
        }
        return 0.5 - 0.5 * (1.0 - Math.exp(-(this.mu - x) / this.b));
    }

    @Override
    public double idf(double p) {
        if (p == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (p >= 0.5) {
            return this.mu - this.b * Math.log(1.0 - 2.0 * (p - 0.5));
        }
        return this.mu + this.b * Math.log(1.0 - 2.0 * (0.5 - p));
    }

    @Override
    public double random() {
        if (this.exponential == null) {
            this.exponential = new ExponentialDistribution(1.0 / this.b);
        }
        double y = this.exponential.random();
        double u = Random.random();
        if (u >= 0.5) {
            return this.mu + y;
        }
        return this.mu - y;
    }

    @Override
    public double mean() {
        return this.mu;
    }

    @Override
    public double variance() {
        return 2.0 * this.b * this.b;
    }

    @Override
    public double skewness() {
        return 0.0;
    }

    @Override
    public double kurtosis() {
        return 3.0;
    }
}

