/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics;

import ikor.math.random.Random;
import ikor.math.statistics.Distribution;

public class LogisticDistribution
implements Distribution {
    private double mu;
    private double sigma;
    private static final double FACTOR = Math.PI / (2.0 * Math.sqrt(3.0));
    private static final double IFACTOR = Math.sqrt(3.0) / Math.PI;

    public LogisticDistribution(double location, double scale) {
        this.mu = location;
        this.sigma = scale;
    }

    @Override
    public double pdf(double x) {
        double e = Math.exp(-FACTOR * Math.abs(x - this.mu) / this.sigma);
        return FACTOR * e / (this.sigma * (1.0 + e) * (1.0 + e));
    }

    @Override
    public double cdf(double x) {
        double e = Math.exp(-FACTOR * Math.abs(x - this.mu) / this.sigma);
        if (x >= this.mu) {
            return 1.0 / (1.0 + e);
        }
        return e / (1.0 + e);
    }

    @Override
    public double idf(double p) {
        return this.mu + IFACTOR * this.sigma * Math.log(p / (1.0 - p));
    }

    @Override
    public double random() {
        double u;
        while ((u = Random.random()) * (1.0 - u) == 0.0) {
        }
        return this.idf(u);
    }

    @Override
    public double mean() {
        return this.mu;
    }

    @Override
    public double variance() {
        return this.sigma * this.sigma * Math.PI * Math.PI / 3.0;
    }

    @Override
    public double skewness() {
        return 0.0;
    }

    @Override
    public double kurtosis() {
        return 1.2;
    }
}

