/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics;

import ikor.math.Constants;
import ikor.math.Functions;
import ikor.math.random.Random;
import ikor.math.statistics.Distribution;

public class LognormalDistribution
implements Distribution {
    private double mu;
    private double sigma;

    public LognormalDistribution(double mu, double sigma) {
        this.mu = mu;
        this.sigma = sigma;
    }

    @Override
    public double pdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        double z = (Math.log(x) - this.mu) / this.sigma;
        return Math.exp(-0.5 * z * z) / (this.sigma * Constants.SQRT2PI * x);
    }

    @Override
    public double cdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        double z = (Math.log(x) - this.mu) / this.sigma;
        return 0.5 * Functions.erfc(-z / Constants.SQRT2);
    }

    @Override
    public double idf(double p) {
        if (p == 0.0) {
            return 0.0;
        }
        return Math.exp(this.mu - Constants.SQRT2 * this.sigma * Functions.erfcinv(2.0 * p));
    }

    @Override
    public double random() {
        return Math.exp(this.mu + this.sigma * Random.gaussian());
    }

    @Override
    public double mean() {
        return Math.exp(this.mu + this.sigma * this.sigma / 2.0);
    }

    @Override
    public double variance() {
        return (Math.exp(this.sigma * this.sigma) - 1.0) * Math.exp(2.0 * this.mu + this.sigma * this.sigma);
    }

    @Override
    public double skewness() {
        return (Math.exp(this.sigma * this.sigma) + 2.0) * Math.sqrt(Math.exp(this.sigma * this.sigma) - 1.0);
    }

    @Override
    public double kurtosis() {
        return Math.exp(4.0 * this.sigma * this.sigma) + 2.0 * Math.exp(3.0 * this.sigma * this.sigma) + 3.0 * Math.exp(2.0 * this.sigma * this.sigma) - 6.0;
    }
}

