/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics;

import ikor.math.Functions;
import ikor.math.statistics.DiscreteDistribution;
import ikor.math.statistics.Distribution;
import ikor.math.statistics.GammaDistribution;
import ikor.math.statistics.PoissonDistribution;

public class NegativeBinomialDistribution
extends DiscreteDistribution
implements Distribution {
    private int r;
    private double p;

    public NegativeBinomialDistribution(int r, double p) {
        this.r = r;
        this.p = p;
    }

    @Override
    public double pdf(double x) {
        int k = (int)x;
        if (k < 0) {
            return 0.0;
        }
        return Math.exp((double)k * Math.log(this.p) + (double)this.r * Math.log(1.0 - this.p) + Functions.logBinomial(k + this.r - 1, k));
    }

    @Override
    public double cdf(double x) {
        int k = (int)x;
        if (k <= 0) {
            return 0.0;
        }
        if ((double)k == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        return 1.0 - Functions.betaI(k + 1, this.r, this.p);
    }

    @Override
    public double idf(double p) {
        if (p == 0.0) {
            return 0.0;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        int k = 0;
        return this.idfsearch(p, k, 0, Integer.MAX_VALUE);
    }

    @Override
    public double random() {
        double g;
        GammaDistribution gamma = new GammaDistribution(this.r, (1.0 - this.p) / this.p);
        while ((g = gamma.random()) == 0.0) {
        }
        return new PoissonDistribution(g).random();
    }

    @Override
    public double mean() {
        return this.p * (double)this.r / (1.0 - this.p);
    }

    @Override
    public double variance() {
        return this.p * (double)this.r / ((1.0 - this.p) * (1.0 - this.p));
    }

    @Override
    public double skewness() {
        return (1.0 + this.p) / Math.sqrt(this.p * (double)this.r);
    }

    @Override
    public double kurtosis() {
        return 6.0 / (double)this.r + (1.0 - this.p) * (1.0 - this.p) / (this.p * (double)this.r);
    }
}

