/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics;

import ikor.math.Constants;
import ikor.math.Functions;
import ikor.math.random.Random;
import ikor.math.statistics.Distribution;

public class NormalDistribution
implements Distribution {
    private double mu;
    private double sigma;

    public NormalDistribution(double mean, double deviation) {
        this.mu = mean;
        this.sigma = deviation;
    }

    @Override
    public double pdf(double x) {
        return Math.exp(-(x - this.mu) * (x - this.mu) / (2.0 * this.sigma * this.sigma)) / (this.sigma * Constants.SQRT2PI);
    }

    @Override
    public double cdf(double x) {
        return Functions.Phi((x - this.mu) / this.sigma);
    }

    @Override
    public double idf(double p) {
        return this.mu + this.sigma * Functions.probit(p);
    }

    @Override
    public double random() {
        return this.mu + this.sigma * Random.gaussian();
    }

    @Override
    public double mean() {
        return this.mu;
    }

    public double deviation() {
        return this.sigma;
    }

    @Override
    public double variance() {
        return this.sigma * this.sigma;
    }

    @Override
    public double skewness() {
        return 0.0;
    }

    @Override
    public double kurtosis() {
        return 0.0;
    }
}

