/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics;

import ikor.math.random.Random;
import ikor.math.statistics.Distribution;

public class ParetoDistribution
implements Distribution {
    private double lambda;
    private double kappa;

    public ParetoDistribution(double shape) {
        this(shape, 1.0);
    }

    public ParetoDistribution(double shape, double scale) {
        this.kappa = shape;
        this.lambda = scale;
    }

    @Override
    public double pdf(double x) {
        if (x > this.lambda) {
            return this.kappa * Math.pow(this.lambda, this.kappa) / Math.pow(x, this.kappa + 1.0);
        }
        return 0.0;
    }

    @Override
    public double cdf(double x) {
        if (x > this.lambda) {
            return 1.0 - Math.pow(this.lambda / x, this.kappa);
        }
        return 0.0;
    }

    @Override
    public double idf(double p) {
        if (p == 0.0) {
            return this.lambda;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.lambda * Math.pow(1.0 - p, -1.0 / this.kappa);
    }

    @Override
    public double random() {
        return this.lambda * Math.pow(Random.random(), -1.0 / this.kappa);
    }

    @Override
    public double mean() {
        if (this.kappa <= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.kappa * this.lambda / (this.kappa - 1.0);
    }

    @Override
    public double variance() {
        if (this.kappa <= 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.kappa * this.lambda * this.lambda / ((this.kappa - 1.0) * (this.kappa - 1.0) * (this.kappa - 2.0));
    }

    @Override
    public double skewness() {
        if (this.kappa <= 3.0) {
            return Double.NaN;
        }
        return 2.0 * (1.0 + this.kappa) / (this.kappa - 3.0) * Math.sqrt((this.kappa - 2.0) / this.kappa);
    }

    @Override
    public double kurtosis() {
        if (this.kappa <= 4.0) {
            return Double.NaN;
        }
        return 6.0 * (this.kappa * this.kappa * this.kappa + this.kappa * this.kappa - 6.0 * this.kappa - 2.0) / (this.kappa * (this.kappa - 3.0) * (this.kappa - 4.0));
    }
}

