/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics;

import ikor.math.Functions;
import ikor.math.random.Random;
import ikor.math.statistics.DiscreteDistribution;
import ikor.math.statistics.Distribution;

public class PoissonDistribution
extends DiscreteDistribution
implements Distribution {
    private double lambda;

    public PoissonDistribution(double lambda) {
        this.lambda = lambda;
    }

    @Override
    public double pdf(double x) {
        int n = (int)x;
        if (n < 0) {
            return 0.0;
        }
        return Math.exp(-this.lambda + (double)n * Math.log(this.lambda) - Functions.logGamma(n + 1));
    }

    @Override
    public double cdf(double x) {
        int n = (int)x;
        if (n <= 0) {
            return 0.0;
        }
        return Functions.gammaQ(n, this.lambda);
    }

    @Override
    public double idf(double p) {
        if (p == 0.0) {
            return 0.0;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (p < Math.exp(-this.lambda)) {
            return 0.0;
        }
        int n = (int)Math.max(Math.sqrt(this.lambda), 5.0);
        return this.idfsearch(p, n, 0, Integer.MAX_VALUE);
    }

    @Override
    public double random() {
        double u = Math.exp(-this.lambda);
        double p = 1.0;
        int k = 0;
        do {
            ++k;
        } while ((p *= Random.random()) >= u);
        return k - 1;
    }

    @Override
    public double mean() {
        return this.lambda;
    }

    @Override
    public double variance() {
        return this.lambda;
    }

    @Override
    public double skewness() {
        return 1.0 / Math.sqrt(this.lambda);
    }

    @Override
    public double kurtosis() {
        return 1.0 / this.lambda;
    }
}

