/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics;

import ikor.math.random.Random;
import ikor.math.statistics.Distribution;

public class RayleighDistribution
implements Distribution {
    private double sigma;

    public RayleighDistribution(double mode) {
        this.sigma = mode;
    }

    @Override
    public double pdf(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return x * Math.exp(-0.5 * (x / this.sigma) * (x / this.sigma)) / (this.sigma * this.sigma);
    }

    @Override
    public double cdf(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return 1.0 - Math.exp(-0.5 * (x / this.sigma) * (x / this.sigma));
    }

    @Override
    public double idf(double p) {
        if (p == 0.0) {
            return 0.0;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double q = 1.0 - p;
        return this.sigma * Math.sqrt(-2.0 * Math.log(q));
    }

    @Override
    public double random() {
        return this.sigma * Math.sqrt(-2.0 * Math.log(Random.random()));
    }

    @Override
    public double mean() {
        return this.sigma * Math.sqrt(1.5707963267948966);
    }

    @Override
    public double variance() {
        return 0.8584073464102069 * this.sigma * this.sigma / 2.0;
    }

    @Override
    public double skewness() {
        return 2.0 * Math.sqrt(Math.PI) * 0.14159265358979312 / Math.pow(0.8584073464102069, 1.5);
    }

    @Override
    public double kurtosis() {
        return 0.2450893006876391;
    }
}

