/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics;

import ikor.math.Functions;
import ikor.math.random.Random;
import ikor.math.statistics.Distribution;

public class StudentTDistribution
implements Distribution {
    private double nu;
    private double mu;
    private double sigma;
    private double np;
    private double fac;

    public StudentTDistribution(double degrees, double center, double width) {
        this.nu = degrees;
        this.mu = center;
        this.sigma = width;
        this.np = 0.5 * (this.nu + 1.0);
        this.fac = Functions.logGamma(this.np) - Functions.logGamma(0.5 * this.nu);
    }

    public StudentTDistribution(double degrees) {
        this(degrees, 0.0, 1.0);
    }

    @Override
    public double pdf(double t) {
        double z = (t - this.mu) / this.sigma;
        return Math.exp(-this.np * Math.log(1.0 + z * z / this.nu) + this.fac) / (Math.sqrt(Math.PI * this.nu) * this.sigma);
    }

    @Override
    public double cdf(double t) {
        double z = (t - this.mu) / this.sigma;
        double p = 0.5 * Functions.betaI(0.5 * this.nu, 0.5, this.nu / (this.nu + z * z));
        if (t >= this.mu) {
            return 1.0 - p;
        }
        return p;
    }

    public double cdf2(double t) {
        return 1.0 - Functions.betaI(0.5 * this.nu, 0.5, this.nu / (this.nu + t * t));
    }

    @Override
    public double idf(double p) {
        double x = Functions.betaIinv(2.0 * Math.min(p, 1.0 - p), 0.5 * this.nu, 0.5);
        x = this.sigma * Math.sqrt(this.nu * (1.0 - x) / x);
        return p >= 0.5 ? this.mu + x : this.mu - x;
    }

    public double idf2(double p) {
        double x = Functions.betaIinv(1.0 - p, 0.5 * this.nu, 0.5);
        return Math.sqrt(this.nu * (1.0 - x) / x);
    }

    @Override
    public double random() {
        double u1 = Random.random();
        double u2 = Random.random();
        double y = Math.sqrt(this.nu * (Math.pow(u1, -2.0 / this.nu) - 1.0)) * Math.cos(Math.PI * 2 * u2);
        return this.mu + this.sigma * y;
    }

    @Override
    public double mean() {
        if (this.nu > 1.0) {
            return 0.0;
        }
        return Double.NaN;
    }

    @Override
    public double variance() {
        if (this.nu <= 1.0) {
            return Double.NaN;
        }
        if (this.nu <= 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.nu / (this.nu - 2.0);
    }

    @Override
    public double skewness() {
        if (this.nu > 3.0) {
            return 0.0;
        }
        return Double.NaN;
    }

    @Override
    public double kurtosis() {
        if (this.nu <= 2.0) {
            return Double.NaN;
        }
        if (this.nu <= 4.0) {
            return Double.POSITIVE_INFINITY;
        }
        return 6.0 / (this.nu - 4.0);
    }
}

