/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics;

import ikor.math.random.Random;
import ikor.math.statistics.Distribution;

public class UniformDistribution
implements Distribution {
    private double min;
    private double max;

    public UniformDistribution(double min, double max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public double pdf(double x) {
        if (x >= this.min && x <= this.max) {
            return 1.0 / (this.max - this.min);
        }
        return 0.0;
    }

    @Override
    public double cdf(double x) {
        if (x <= this.min) {
            return 0.0;
        }
        if (x >= this.max) {
            return 1.0;
        }
        return (x - this.min) / (this.max - this.min);
    }

    @Override
    public double idf(double p) {
        return this.min + p * (this.max - this.min);
    }

    @Override
    public double random() {
        return this.idf(Random.random());
    }

    @Override
    public double mean() {
        return (this.min + this.max) / 2.0;
    }

    @Override
    public double variance() {
        return (this.max - this.min) * (this.max - this.min) / 12.0;
    }

    @Override
    public double skewness() {
        return 0.0;
    }

    @Override
    public double kurtosis() {
        return -1.2;
    }
}

