/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics;

import ikor.math.Configuration;
import ikor.math.Constants;
import ikor.math.Functions;
import ikor.math.random.Random;
import ikor.math.statistics.Distribution;

public class WaldDistribution
implements Distribution {
    private double mu;
    private double lambda;

    public WaldDistribution(double mu, double lambda) {
        this.mu = mu;
        this.lambda = lambda;
    }

    @Override
    public double pdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return Math.sqrt(this.lambda / (x * x * x)) / Constants.SQRT2PI * Math.exp(-this.lambda * (x - this.mu) * (x - this.mu) / (2.0 * this.mu * this.mu * x));
    }

    @Override
    public double cdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        double d = x / this.mu;
        double r = Math.sqrt(this.lambda / x);
        return Functions.Phi(r * (d - 1.0)) + Math.exp(2.0 * this.lambda / this.mu) * Functions.Phi(-r * (d + 1.0));
    }

    @Override
    public double idf(double p) {
        if (p == 0.0) {
            return 0.0;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.idfsearch(p, 0.0, 1000000.0);
    }

    private double idfsearch(double p, double min, double max) {
        double v = min;
        while (max - min > Configuration.EPSILON) {
            v = (min + max) / 2.0;
            if (p <= this.cdf(v)) {
                max = v;
                continue;
            }
            min = v;
        }
        return v;
    }

    @Override
    public double random() {
        double v = Random.gaussian();
        double y = v * v;
        double x = this.mu + this.mu * this.mu * y / (2.0 * this.lambda) - this.mu / (2.0 * this.lambda) * Math.sqrt(4.0 * this.mu * this.lambda * y + this.mu * this.mu * y * y);
        double test = Random.random();
        if (test <= this.mu / (this.mu + x)) {
            return x;
        }
        return this.mu * this.mu / x;
    }

    @Override
    public double mean() {
        return this.mu;
    }

    @Override
    public double variance() {
        return this.mu * this.mu * this.mu / this.lambda;
    }

    @Override
    public double skewness() {
        return 3.0 * Math.sqrt(this.mu / this.lambda);
    }

    @Override
    public double kurtosis() {
        return 15.0 * this.mu / this.lambda;
    }
}

