/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics;

import ikor.math.Functions;
import ikor.math.random.Random;
import ikor.math.statistics.Distribution;

public class WeibullDistribution
implements Distribution {
    private double alpha;
    private double beta;

    public WeibullDistribution(double alpha, double beta) {
        this.alpha = alpha;
        this.beta = beta;
    }

    @Override
    public double pdf(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return this.alpha / this.beta * Math.pow(x / this.beta, this.alpha - 1.0) * Math.exp(-Math.pow(x / this.beta, this.alpha));
    }

    @Override
    public double cdf(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return 1.0 - Math.exp(-Math.pow(x / this.beta, this.alpha));
    }

    @Override
    public double idf(double p) {
        if (p == 0.0) {
            return 0.0;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.beta * Math.pow(-Math.log(1.0 - p), 1.0 / this.alpha);
    }

    @Override
    public double random() {
        return this.idf(Random.random());
    }

    @Override
    public double mean() {
        return this.beta * Functions.gamma(1.0 + 1.0 / this.alpha);
    }

    @Override
    public double variance() {
        double mu = this.mean();
        return this.beta * this.beta * Functions.gamma(1.0 + 2.0 / this.alpha) - mu * mu;
    }

    @Override
    public double skewness() {
        double mu = this.mean();
        double sigma2 = this.variance();
        return (this.beta * this.beta * this.beta * Functions.gamma(1.0 + 3.0 / this.alpha) - 3.0 * mu * sigma2 - mu * mu * mu) / Math.pow(sigma2, 1.5);
    }

    @Override
    public double kurtosis() {
        double mu = this.mean();
        double sigma2 = this.variance();
        double gamma1 = this.skewness();
        return (this.beta * this.beta * this.beta * this.beta * Functions.gamma(1.0 + 4.0 / this.alpha) - 4.0 * gamma1 * Math.pow(sigma2, 1.5) * mu - 6.0 * mu * mu * sigma2 - mu * mu * mu * mu) / (sigma2 * sigma2) - 3.0;
    }
}

