/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics.fit;

import ikor.math.MatrixFactory;
import ikor.math.Vector;
import ikor.math.statistics.ChiSquaredDistribution;
import ikor.math.statistics.NormalDistribution;
import ikor.math.statistics.StudentTDistribution;
import ikor.math.statistics.fit.ConfidenceInterval;
import ikor.math.statistics.fit.DistributionFit;

public class NormalDistributionFit
implements DistributionFit<NormalDistribution> {
    private Vector data;

    public NormalDistributionFit(Vector data) {
        this.data = data;
    }

    public NormalDistributionFit(double[] data) {
        this.data = MatrixFactory.createVector(data);
    }

    @Override
    public NormalDistribution fit() {
        return new NormalDistribution(this.sampleMean(), this.sampleDeviation());
    }

    public double mleMean() {
        return this.data.average();
    }

    public double mleVariance() {
        return this.data.variance();
    }

    public double mleDeviation() {
        return this.data.deviation();
    }

    public double sampleMean() {
        return this.data.average();
    }

    public double sampleVariance() {
        return this.data.sampleVariance();
    }

    public double sampleDeviation() {
        return this.data.sampleDeviation();
    }

    public ConfidenceInterval mean(double alpha) {
        int n = this.data.size();
        double mu = this.sampleMean();
        double s = Math.sqrt(this.sampleVariance());
        StudentTDistribution t = new StudentTDistribution(n - 1);
        double min = mu + t.idf(alpha / 2.0) * s / Math.sqrt(n);
        double max = mu + t.idf(1.0 - alpha / 2.0) * s / Math.sqrt(n);
        return new ConfidenceInterval(min, max, alpha);
    }

    public ConfidenceInterval variance(double alpha) {
        int n = this.data.size();
        double s2 = this.sampleVariance();
        ChiSquaredDistribution chi2 = new ChiSquaredDistribution(n - 1);
        double min = (double)(n - 1) * s2 / chi2.idf(1.0 - alpha / 2.0);
        double max = (double)(n - 1) * s2 / chi2.idf(alpha / 2.0);
        return new ConfidenceInterval(min, max, alpha);
    }

    public ConfidenceInterval deviation(double alpha) {
        ConfidenceInterval variance = this.variance(alpha);
        return new ConfidenceInterval(Math.sqrt(variance.min()), Math.sqrt(variance.max()), alpha);
    }
}

