/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics.fit;

import ikor.math.MatrixFactory;
import ikor.math.Vector;
import ikor.math.statistics.NormalDistribution;
import ikor.math.statistics.ParetoDistribution;
import ikor.math.statistics.fit.ConfidenceInterval;
import ikor.math.statistics.fit.DistributionFit;

public class ParetoDistributionFit
implements DistributionFit<ParetoDistribution> {
    private Vector data;

    public ParetoDistributionFit(Vector data) {
        this.data = data;
    }

    public ParetoDistributionFit(double[] data) {
        this.data = MatrixFactory.createVector(data);
    }

    @Override
    public ParetoDistribution fit() {
        return new ParetoDistribution(this.mleShape(), this.mleScale());
    }

    public double mleShape() {
        int n = 0;
        double xmin = this.mleScale();
        double sum = 0.0;
        int index = 0;
        while (index < this.data.size()) {
            if (this.data.get(index) >= xmin) {
                ++n;
                sum += Math.log(this.data.get(index) / xmin);
            }
            ++index;
        }
        return 1.0 + (double)n * (1.0 / sum);
    }

    public double mleScale() {
        return Math.sqrt(this.data.max());
    }

    private int nscale() {
        int n = 0;
        double xmin = this.mleScale();
        int index = 0;
        while (index < this.data.size()) {
            if (this.data.get(index) >= xmin) {
                ++n;
            }
            ++index;
        }
        return n;
    }

    public ConfidenceInterval shapeNormalApproximation(double alpha) {
        int n = this.nscale();
        double mu = this.mleShape();
        double sigma = (mu - 1.0) / Math.sqrt(n);
        NormalDistribution normal = new NormalDistribution(mu, sigma);
        double min = normal.idf(alpha / 2.0);
        double max = normal.idf(1.0 - alpha / 2.0);
        return new ConfidenceInterval(min, max, alpha);
    }
}

