/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics.fit;

import ikor.math.MatrixFactory;
import ikor.math.Vector;
import ikor.math.statistics.ChiSquaredDistribution;
import ikor.math.statistics.NormalDistribution;
import ikor.math.statistics.PoissonDistribution;
import ikor.math.statistics.fit.ConfidenceInterval;
import ikor.math.statistics.fit.DistributionFit;

public class PoissonDistributionFit
implements DistributionFit<PoissonDistribution> {
    private Vector data;

    public PoissonDistributionFit(Vector data) {
        this.data = data;
    }

    public PoissonDistributionFit(double[] data) {
        this.data = MatrixFactory.createVector(data);
    }

    @Override
    public PoissonDistribution fit() {
        return new PoissonDistribution(this.mleLambda());
    }

    public double mleLambda() {
        return this.data.average();
    }

    public ConfidenceInterval lambda(double alpha) {
        int n = this.data.size();
        int k = (int)this.data.sum();
        ChiSquaredDistribution chi2min = new ChiSquaredDistribution(2 * k);
        double min = chi2min.idf(alpha / 2.0) / (double)(2 * n);
        ChiSquaredDistribution chi2max = new ChiSquaredDistribution(2 * k + 2);
        double max = chi2max.idf(1.0 - alpha / 2.0) / (double)(2 * n);
        return new ConfidenceInterval(min, max, alpha);
    }

    public ConfidenceInterval lambdaNormalApproximation(double alpha) {
        int n = this.data.size();
        double mu = this.data.sum();
        double sigma = Math.sqrt(mu);
        NormalDistribution normal = new NormalDistribution(mu, sigma);
        double min = normal.idf(alpha / 2.0) / (double)n;
        double max = normal.idf(1.0 - alpha / 2.0) / (double)n;
        return new ConfidenceInterval(min, max, alpha);
    }
}

