/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics.test;

import ikor.math.MatrixFactory;
import ikor.math.Vector;
import ikor.math.statistics.ChiSquaredDistribution;
import ikor.math.statistics.test.Rank;

public class FriedmanTest {
    int n;
    int nc;
    Vector[] data;
    Vector[] rank;

    public FriedmanTest(Vector[] columns) {
        this.n = columns[0].size();
        this.nc = columns.length;
        this.data = columns;
        this.rank = this.rank(this.data);
    }

    private Vector[] rank(Vector[] columns) {
        Vector row = MatrixFactory.createVector(this.nc);
        this.rank = new Vector[this.nc];
        int j = 0;
        while (j < this.nc) {
            this.rank[j] = MatrixFactory.createVector(this.n);
            ++j;
        }
        int i = 0;
        while (i < this.n) {
            int j2 = 0;
            while (j2 < this.nc) {
                row.set(j2, columns[j2].get(i));
                ++j2;
            }
            Rank rankedRow = new Rank(row);
            j2 = 0;
            while (j2 < this.nc) {
                this.rank[j2].set(i, rankedRow.rank(j2));
                ++j2;
            }
            ++i;
        }
        return this.rank;
    }

    public int n() {
        return this.n;
    }

    public int nc() {
        return this.nc;
    }

    public int df() {
        return this.nc - 1;
    }

    public Vector rank(int i) {
        return this.rank[i];
    }

    public double meanrank(int i) {
        return this.rank[i].average();
    }

    public double meanrank() {
        double sum = 0.0;
        int i = 0;
        while (i < this.nc) {
            sum += this.meanrank(i);
            ++i;
        }
        return sum / (double)this.nc;
    }

    public double sst() {
        double meanrank = this.meanrank();
        double sum2 = 0.0;
        int i = 0;
        while (i < this.nc) {
            double diff = this.meanrank(i) - meanrank;
            sum2 += diff * diff;
            ++i;
        }
        return (double)this.n * sum2;
    }

    public double mst() {
        return this.sst() / (double)this.df();
    }

    public double sse() {
        double meanrank = this.meanrank();
        double sum2 = 0.0;
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.nc) {
                double diff = this.rank[j].get(i) - meanrank;
                sum2 += diff * diff;
                ++j;
            }
            ++i;
        }
        return sum2 / (double)(this.n * (this.nc - 1));
    }

    public int dfe() {
        return (this.n - 1) * (this.nc - 1);
    }

    public double mse() {
        return this.sse() / (double)this.dfe();
    }

    public double q() {
        return this.sst() / this.sse();
    }

    public double pvalue() {
        ChiSquaredDistribution chi2 = new ChiSquaredDistribution(this.df());
        return 1.0 - chi2.cdf(this.q());
    }
}

