/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics.test;

import ikor.math.Vector;
import ikor.math.statistics.test.TTest;

public class OneTailedTTest
extends TTest {
    private Tail tail;

    public OneTailedTTest(Vector data, Tail tail) {
        super(data);
        this.tail = tail;
    }

    public OneTailedTTest(Vector data, double mean, Tail tail) {
        super(data, mean);
        this.tail = tail;
    }

    public OneTailedTTest(Vector x, Vector y, Tail tail) {
        this(x.subtract(y), tail);
    }

    public OneTailedTTest(Vector x, Vector y, double mean, Tail tail) {
        this(x.subtract(y), mean, tail);
    }

    @Override
    public double pvalue() {
        if (this.tail == Tail.RIGHT) {
            return this.tdist.cdf(-this.tstat());
        }
        return this.tdist.cdf(this.tstat());
    }

    private double criticalValue(double alpha) {
        return this.tdist.idf(1.0 - alpha) * this.sd() / Math.sqrt(this.data.size());
    }

    @Override
    public double minConfidenceInterval(double alpha) {
        if (this.tail == Tail.RIGHT) {
            return this.data.average() - this.criticalValue(alpha);
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double maxConfidenceInterval(double alpha) {
        if (this.tail == Tail.RIGHT) {
            return Double.POSITIVE_INFINITY;
        }
        return this.data.average() + this.criticalValue(alpha);
    }

    public static enum Tail {
        LEFT,
        RIGHT;

    }
}

