/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics.test;

import ikor.math.MatrixFactory;
import ikor.math.Vector;

public class Rank {
    private Vector data;
    private Vector rank;
    private int[] index;
    private double tieadjustment;

    public Rank(Vector data) {
        this.data = data;
        this.index = this.sort(data);
        this.rank = this.tiedrank(data, this.index);
    }

    private int[] sort(Vector data) {
        int n = data.size();
        this.index = new int[n];
        int i = 0;
        while (i < data.size()) {
            this.index[i] = i;
            ++i;
        }
        i = 0;
        while (i < n - 1) {
            int min = i;
            int j = i + 1;
            while (j < n) {
                if (data.get(this.index[j]) < data.get(this.index[min])) {
                    min = j;
                }
                ++j;
            }
            int tmp = this.index[i];
            this.index[i] = this.index[min];
            this.index[min] = tmp;
            ++i;
        }
        return this.index;
    }

    private Vector tiedrank(Vector data, int[] index) {
        int n = data.size();
        Vector ranked = MatrixFactory.createVector(n);
        int current = 0;
        this.tieadjustment = 0.0;
        while (current < n) {
            int next = current + 1;
            double rank = next;
            while (next < n && data.get(index[current]) == data.get(index[next])) {
                rank += (double)(++next);
            }
            rank /= (double)(next - current);
            int ntied = next - current;
            this.tieadjustment += (double)(ntied * (ntied - 1) * (ntied + 1) / 2);
            int j = current;
            while (j < next) {
                ranked.set(index[j], rank);
                ++j;
            }
            current = next;
        }
        return ranked;
    }

    public Vector data() {
        return this.data;
    }

    public Vector rank() {
        return this.rank;
    }

    public double rank(int i) {
        return this.rank.get(i);
    }

    public double tieAdjustment() {
        return this.tieadjustment;
    }
}

