/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics.test;

import ikor.math.Vector;
import ikor.math.statistics.StudentTDistribution;

public class TTest {
    protected Vector data;
    protected double mean;
    protected StudentTDistribution tdist;

    public TTest(Vector data) {
        this(data, 0.0);
    }

    public TTest(Vector data, double mean) {
        this.data = data;
        this.mean = mean;
        this.tdist = new StudentTDistribution(this.df());
    }

    public TTest(Vector x, Vector y) {
        this(x.subtract(y));
    }

    public TTest(Vector x, Vector y, double mean) {
        this(x.subtract(y), mean);
    }

    public double tstat() {
        double sampleMean = this.data.average();
        double sampleSize = this.data.size();
        return (sampleMean - this.mean) / this.sd() * Math.sqrt(sampleSize);
    }

    public int df() {
        return this.data.size() - 1;
    }

    public double sd() {
        return this.data.sampleDeviation();
    }

    public double pvalue() {
        return 2.0 * this.tdist.cdf(-Math.abs(this.tstat()));
    }

    private double criticalValue(double alpha) {
        return this.tdist.idf(1.0 - alpha / 2.0) * this.sd() / Math.sqrt(this.data.size());
    }

    public double minConfidenceInterval(double alpha) {
        return this.data.average() - this.criticalValue(alpha);
    }

    public double maxConfidenceInterval(double alpha) {
        return this.data.average() + this.criticalValue(alpha);
    }
}

