/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.statistics.test;

import ikor.math.MatrixFactory;
import ikor.math.Vector;
import ikor.math.statistics.NormalDistribution;
import ikor.math.statistics.test.Rank;

public class WilcoxonTest {
    private int n;
    private int nr;
    private Vector signrank;
    private Rank rank;
    private static NormalDistribution normal = new NormalDistribution(0.0, 1.0);

    public WilcoxonTest(Vector x) {
        Vector reduced = this.reduce(x);
        Vector sign = this.sign(reduced);
        Vector absolute = this.abs(reduced);
        this.n = x.size();
        this.nr = reduced.size();
        this.rank = new Rank(absolute);
        this.signrank = sign.arrayMultiply(this.rank.rank());
    }

    public WilcoxonTest(Vector x, double median) {
        this(x.subtract(median));
    }

    public WilcoxonTest(Vector x, Vector y) {
        this(y.subtract(x));
    }

    public WilcoxonTest(Vector x, Vector y, double median) {
        this(y.subtract(x), median);
    }

    private Vector reduce(Vector x) {
        int nonzero = 0;
        int i = 0;
        while (i < x.size()) {
            if (x.get(i) != 0.0 && !Double.isNaN(x.get(i))) {
                ++nonzero;
            }
            ++i;
        }
        Vector reduced = MatrixFactory.createVector(nonzero);
        int pos = 0;
        int i2 = 0;
        while (i2 < x.size()) {
            if (x.get(i2) != 0.0 && !Double.isNaN(x.get(i2))) {
                reduced.set(pos, x.get(i2));
                ++pos;
            }
            ++i2;
        }
        return reduced;
    }

    private Vector sign(Vector x) {
        Vector sgn = MatrixFactory.createVector(x.size());
        int i = 0;
        while (i < x.size()) {
            if (x.get(i) > 0.0) {
                sgn.set(i, 1.0);
            } else if (x.get(i) < 0.0) {
                sgn.set(i, -1.0);
            } else {
                sgn.set(i, 0.0);
            }
            ++i;
        }
        return sgn;
    }

    private Vector abs(Vector x) {
        Vector absolute = MatrixFactory.createVector(x.size());
        int i = 0;
        while (i < x.size()) {
            absolute.set(i, Math.abs(x.get(i)));
            ++i;
        }
        return absolute;
    }

    public double signedrank() {
        return Math.abs(this.signrank.sum());
    }

    public int n() {
        return this.n;
    }

    public int nr() {
        return this.nr;
    }

    public double mu() {
        return 0.0;
    }

    public double sigma() {
        return Math.sqrt(this.nr * (this.nr + 1) * (2 * this.nr + 1) / 6);
    }

    public double adjustedSigma() {
        return Math.sqrt(((double)(this.n * (this.n + 1) * (2 * this.n + 1)) - this.rank.tieAdjustment()) / 24.0);
    }

    public double zvalue() {
        double w = this.signedrank();
        if (this.nr > 0) {
            return (w - 0.5) / this.sigma();
        }
        return Double.POSITIVE_INFINITY;
    }

    public double pvalue() {
        if (this.nr > 0) {
            return 2.0 * (1.0 - normal.cdf(Math.abs(this.zvalue())));
        }
        return 1.0;
    }

    public double w(double alpha) {
        return this.mu() + this.sigma() * normal.idf(1.0 - alpha / 2.0);
    }
}

