/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.util;

import ikor.math.util.Scale;

public class LogarithmicScale
extends Scale {
    private double min;
    private double max;

    public LogarithmicScale(double min, double max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public double scale(double value) {
        if (value > 0.0) {
            return Math.log(value / this.min) / Math.log(this.max / this.min);
        }
        return 0.0;
    }

    @Override
    public double inverse(double value) {
        return this.min * Math.pow(this.max / this.min, value);
    }

    @Override
    public double min() {
        return this.min;
    }

    @Override
    public double max() {
        return this.max;
    }
}

