/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.util;

import ikor.math.util.Scale;

public class LogarithmicTransformation
extends Scale {
    public static final double DEFAULT_RANGE = Math.exp(2.0);
    private double min;
    private double max;
    private double range;

    public LogarithmicTransformation(double min, double max) {
        this.min = min;
        this.max = max;
        this.range = DEFAULT_RANGE;
    }

    public LogarithmicTransformation(double min, double max, double range) {
        this.min = min;
        this.max = max;
        this.range = range;
    }

    @Override
    public double scale(double value) {
        return Math.log(this.range * (value - this.min) + 1.0) / Math.log(this.range * (this.max - this.min) + 1.0);
    }

    @Override
    public double inverse(double value) {
        return this.min + (Math.pow(this.range * (this.max - this.min) + 1.0, value) - 1.0) / this.range;
    }

    @Override
    public double min() {
        return this.min;
    }

    @Override
    public double max() {
        return this.max;
    }
}

