/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.data;

import ikor.collection.Dictionary;
import ikor.collection.DynamicDictionary;
import ikor.math.Decimal;
import ikor.model.data.BooleanModel;
import ikor.model.data.ColorModel;
import ikor.model.data.DataModel;
import ikor.model.data.Dataset;
import ikor.model.data.DatasetModel;
import ikor.model.data.DateModel;
import ikor.model.data.DecimalModel;
import ikor.model.data.IntegerModel;
import ikor.model.data.RealModel;
import ikor.model.data.TextModel;
import java.awt.Color;
import java.util.Date;

public class DataModelFactory {
    Dictionary<Class, Class> models = new DynamicDictionary<Class, Class>();
    private static DataModelFactory singleton;

    public DataModelFactory() {
        this.models.set(String.class, TextModel.class);
        this.models.set(Integer.class, IntegerModel.class);
        this.models.set(Long.class, IntegerModel.class);
        this.models.set(Short.class, IntegerModel.class);
        this.models.set(Byte.class, IntegerModel.class);
        this.models.set(Float.class, RealModel.class);
        this.models.set(Double.class, RealModel.class);
        this.models.set(Decimal.class, DecimalModel.class);
        this.models.set(Boolean.class, BooleanModel.class);
        this.models.set(Date.class, DateModel.class);
        this.models.set(Dataset.class, DatasetModel.class);
        this.models.set(Color.class, ColorModel.class);
    }

    public DataModel createDataModel(Class type) {
        Class modelClass = this.getDataModelClass(type);
        DataModel model = null;
        if (type != null) {
            try {
                model = (DataModel)modelClass.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return model;
    }

    public Class getDataModelClass(Class type) {
        Class model = (Class)this.models.get(type);
        if (model != null) {
            return model;
        }
        if (type.getSuperclass() != null) {
            return this.getDataModelClass(type.getSuperclass());
        }
        return null;
    }

    public static DataModelFactory getInstance() {
        if (singleton == null) {
            singleton = new DataModelFactory();
        }
        return singleton;
    }

    public static DataModel create(Class type) {
        return DataModelFactory.getInstance().createDataModel(type);
    }
}

