/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.data;

import ikor.collection.ReadOnlyList;
import ikor.model.data.DataModel;
import ikor.model.data.DatasetModel;
import ikor.model.data.Record;
import java.util.Iterator;

public abstract class Dataset
implements ReadOnlyList<Record> {
    public abstract Object get(int var1, int var2);

    public abstract void set(int var1, int var2, Object var3);

    public abstract int getColumnCount();

    public abstract int getRowCount();

    public abstract DataModel getModel(int var1);

    public final DatasetModel getModel() {
        DatasetModel model = new DatasetModel();
        int i = 0;
        while (i < this.getColumnCount()) {
            model.add(this.getModel(i));
            ++i;
        }
        return model;
    }

    public Column getColumn(int index) {
        if (index >= 0 && index < this.getColumnCount()) {
            return new Column(this, index);
        }
        return null;
    }

    public Record getRow(int index) {
        if (index >= 0 && index < this.getRowCount()) {
            return new Record(this, index);
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this.getRowCount()) + "x" + this.getColumnCount() + " dataset";
    }

    @Override
    public final Record get(int index) {
        return this.getRow(index);
    }

    @Override
    public final int index(Record object) {
        if (object.getDataset() == this) {
            return object.getIndex();
        }
        return -1;
    }

    @Override
    public final int size() {
        return this.getRowCount();
    }

    @Override
    public boolean contains(Record object) {
        return object.getDataset() == this && object.getIndex() >= 0 && object.getIndex() < this.size();
    }

    @Override
    public Iterator<Record> iterator() {
        return new DatasetIterator();
    }

    public class Column
    extends Dataset {
        Dataset dataset;
        int index;

        public Column(Dataset dataset2, int index) {
            this.dataset = dataset2;
            this.index = index;
        }

        public Dataset getDataset() {
            return this.dataset;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public Object get(int row, int column) {
            if (column == 0) {
                return this.dataset.get(row, this.index);
            }
            return null;
        }

        @Override
        public void set(int row, int column, Object object) {
            if (column == 0) {
                this.dataset.set(row, this.index, object);
            }
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return this.dataset.getRowCount();
        }

        @Override
        public DataModel getModel(int column) {
            if (column == 0) {
                return this.dataset.getModel(this.index);
            }
            return null;
        }
    }

    public class DatasetIterator
    implements Iterator<Record> {
        private int current = 0;

        @Override
        public boolean hasNext() {
            return this.current < Dataset.this.size();
        }

        @Override
        public Record next() {
            return Dataset.this.get(this.current++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unsupported dataset removal through iterator");
        }
    }
}

