/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.data;

import ikor.model.data.DataModel;
import java.text.NumberFormat;
import java.util.Locale;

public abstract class NumberModel<T extends Number>
implements DataModel<T> {
    private T minimumValue;
    private T maximumValue;

    @Override
    public String toString(Number object) {
        return NumberFormat.getNumberInstance(Locale.US).format(object);
    }

    public T getMinimumValue() {
        return this.minimumValue;
    }

    public void setMinimumValue(T minimumValue) {
        this.minimumValue = minimumValue;
    }

    public T getMaximumValue() {
        return this.maximumValue;
    }

    public void setMaximumValue(T maximumValue) {
        this.maximumValue = maximumValue;
    }

    public boolean check(T value) {
        if (this.getMinimumValue() != null && ((Comparable)this.getMinimumValue()).compareTo(value) > 0) {
            return false;
        }
        return this.getMaximumValue() == null || ((Comparable)this.getMaximumValue()).compareTo(value) >= 0;
    }
}

