/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.graphics;

import ikor.model.graphics.Ellipse;
import ikor.model.graphics.Style;

public class Arc
extends Ellipse {
    private double startAngle;
    private double extent;

    public Arc(String id, Style style, Style border, int centerX, int centerY, int radius, double startAngle, double extent) {
        super(id, style, border, centerX, centerY, radius, radius);
        this.startAngle = startAngle;
        this.extent = extent;
    }

    public Arc(String id, Style style, Style border, int centerX, int centerY, int radiusX, int radiusY, double startAngle, double extent) {
        super(id, style, border, centerX, centerY, radiusX, radiusY);
        this.startAngle = startAngle;
        this.extent = extent;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double startAngle) {
        this.startAngle = startAngle;
    }

    public double getExtent() {
        return this.extent;
    }

    public void setExtent(double extent) {
        this.extent = extent;
    }

    public double getEndAngle() {
        return this.startAngle + this.extent;
    }

    public void setEndAngle(double endAngle) {
        this.extent = endAngle - this.startAngle;
    }

    @Override
    public String toString() {
        return String.valueOf(String.format("a%.3f+%.3f", this.startAngle, this.extent)) + super.toString();
    }

    @Override
    public boolean containsPoint(int rx, int ry) {
        boolean in = super.containsPoint(rx, ry);
        if (in) {
            double cx = this.getCenterX();
            double cy = this.getCenterY();
            double px = this.getUnrotatedX(cx, cy, rx, ry);
            double py = this.getUnrotatedY(cx, cy, rx, ry);
            double angle = Math.atan2(cy - py, px - cx);
            if (angle < 0.0) {
                angle += Math.PI * 2;
            }
            in = angle >= this.startAngle && angle <= this.startAngle + this.extent;
        }
        return in;
    }
}

