/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.graphics;

import ikor.model.graphics.Shape;
import ikor.model.graphics.Style;

public class Circle
extends Shape {
    private int centerX;
    private int centerY;
    private int radius;

    public Circle(String id, Style style, Style border, int centerX, int centerY, int radius) {
        super(id, style, border);
        this.centerX = centerX;
        this.centerY = centerY;
        this.radius = radius;
    }

    public int getCenterX() {
        return this.centerX;
    }

    public void setCenterX(int x) {
        this.centerX = x;
    }

    public int getCenterY() {
        return this.centerY;
    }

    public void setCenterY(int y) {
        this.centerY = y;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public String toString() {
        return String.format("c(%d,%d)r%d", this.centerX, this.centerY, this.radius);
    }

    @Override
    public int getWidth() {
        return 2 * this.radius;
    }

    @Override
    public int getHeight() {
        return 2 * this.radius;
    }

    @Override
    public int getX() {
        return this.centerX - this.radius;
    }

    @Override
    public int getY() {
        return this.centerY - this.radius;
    }

    @Override
    public boolean containsPoint(int x, int y) {
        return (x - this.centerX) * (x - this.centerX) + (y - this.centerY) * (y - this.centerY) <= this.radius * this.radius;
    }
}

