/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.graphics;

import ikor.collection.Dictionary;
import ikor.collection.DynamicDictionary;
import ikor.collection.DynamicList;
import ikor.collection.List;
import ikor.collection.ReadOnlyCollection;
import ikor.model.graphics.DrawingElement;
import ikor.model.graphics.Style;

public class Drawing {
    private int width;
    private int height;
    private List<DrawingElement> elements;
    private Dictionary<String, DrawingElement> index;

    public Drawing(int width, int height) {
        this.width = width;
        this.height = height;
        this.elements = new DynamicList<DrawingElement>();
        this.index = new DynamicDictionary<String, DrawingElement>();
    }

    public void clear() {
        this.elements.clear();
        this.index.clear();
    }

    public void add(DrawingElement element) {
        this.elements.add(element);
        if (element.getId() != null) {
            this.index.set(element.getId(), element);
        }
    }

    public void remove(DrawingElement element) {
        this.elements.remove(element);
        if (element.getId() != null) {
            this.index.remove(element.getId());
        }
    }

    public ReadOnlyCollection<DrawingElement> getElements() {
        return this.elements;
    }

    public DrawingElement getDrawingElement(String id) {
        return (DrawingElement)this.index.get(id);
    }

    public DrawingElement getDrawingElement(int x, int y) {
        int i = this.elements.size() - 1;
        while (i >= 0) {
            DrawingElement element = (DrawingElement)this.elements.get(i);
            if (element.containsPoint(x, y)) {
                return element;
            }
            --i;
        }
        return null;
    }

    public String getElement(int x, int y) {
        DrawingElement element = this.getDrawingElement(x, y);
        if (element != null) {
            return element.getId();
        }
        return null;
    }

    public ReadOnlyCollection<Style> getStyles() {
        DynamicDictionary<String, Style> styles = new DynamicDictionary<String, Style>();
        for (DrawingElement element : this.elements) {
            Style style = element.getStyle();
            if (style != null) {
                styles.set(style.toString(), style);
            }
            if ((style = element.getBorder()) == null) continue;
            styles.set(style.toString(), style);
        }
        return styles.values();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void update() {
    }
}

