/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.graphics;

import ikor.model.graphics.Shape;
import ikor.model.graphics.Style;

public class Ellipse
extends Shape {
    private int centerX;
    private int centerY;
    private int radiusX;
    private int radiusY;

    public Ellipse(String id, Style style, Style border, int centerX, int centerY, int radiusX, int radiusY) {
        super(id, style, border);
        this.centerX = centerX;
        this.centerY = centerY;
        this.radiusX = radiusX;
        this.radiusY = radiusY;
    }

    public int getCenterX() {
        return this.centerX;
    }

    public void setCenterX(int x) {
        this.centerX = x;
    }

    public int getCenterY() {
        return this.centerY;
    }

    public void setCenterY(int y) {
        this.centerY = y;
    }

    public int getRadiusX() {
        return this.radiusX;
    }

    public void setRadiusX(int radiusX) {
        this.radiusX = radiusX;
    }

    public int getRadiusY() {
        return this.radiusY;
    }

    public void setRadiusY(int radiusY) {
        this.radiusY = radiusY;
    }

    public String toString() {
        return String.format("e(%d,%d)r(%d,%d)", this.centerX, this.centerY, this.radiusX, this.radiusY);
    }

    @Override
    public int getWidth() {
        return 2 * this.radiusX;
    }

    @Override
    public int getHeight() {
        return 2 * this.radiusY;
    }

    @Override
    public int getX() {
        return this.centerX - this.radiusX;
    }

    @Override
    public int getY() {
        return this.centerY - this.radiusY;
    }

    @Override
    public boolean containsPoint(int rx, int ry) {
        double rx2;
        double py;
        double ry2;
        double px = this.getUnrotatedX(this.centerX, this.centerY, rx, ry);
        return (px - (double)this.centerX) * (px - (double)this.centerX) * (ry2 = (double)(this.radiusY * this.radiusY)) + ((py = this.getUnrotatedY(this.centerX, this.centerY, rx, ry)) - (double)this.centerY) * (py - (double)this.centerY) * (rx2 = (double)(this.radiusX * this.radiusX)) <= rx2 * ry2;
    }
}

