/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.graphics;

import ikor.model.graphics.DrawingElement;
import ikor.model.graphics.Style;

public class Line
extends DrawingElement {
    private int startX;
    private int startY;
    private int endX;
    private int endY;

    public Line(String id, Style style, int startX, int startY, int endX, int endY) {
        super(id, style, style);
        this.startX = startX;
        this.startY = startY;
        this.endX = endX;
        this.endY = endY;
    }

    public int getStartX() {
        return this.startX;
    }

    public void setStartX(int startX) {
        this.startX = startX;
    }

    public int getStartY() {
        return this.startY;
    }

    public void setStartY(int startY) {
        this.startY = startY;
    }

    public int getEndX() {
        return this.endX;
    }

    public void setEndX(int endX) {
        this.endX = endX;
    }

    public int getEndY() {
        return this.endY;
    }

    public void setEndY(int endY) {
        this.endY = endY;
    }

    public String toString() {
        return String.format("l(%d,%d)(%d,%d)", this.startX, this.startY, this.endX, this.endY);
    }

    @Override
    public int getWidth() {
        return Math.abs(this.endX - this.startX);
    }

    @Override
    public int getHeight() {
        return Math.abs(this.endY - this.startY);
    }

    @Override
    public int getX() {
        return Math.min(this.startX, this.endX);
    }

    public int getMaxX() {
        return Math.max(this.startX, this.endX);
    }

    @Override
    public int getY() {
        return Math.min(this.startY, this.endY);
    }

    public int getMaxY() {
        return Math.max(this.startY, this.endY);
    }

    @Override
    public boolean containsPoint(int x, int y) {
        float width = this.getStyle().getWidth();
        if (x >= this.getX() && x <= this.getMaxX() && y >= this.getY() && y <= this.getMaxY()) {
            return this.distance(x, y) <= width / 2.0f;
        }
        return false;
    }

    public float distance(float x, float y) {
        return (float)Math.sqrt(this.squaredDistance(x, y));
    }

    public float squaredDistance(float x, float y) {
        float t;
        float length = this.distance2(this.startX, this.startY, this.endX, this.endY);
        float d = length == 0.0f ? this.distance2(this.startX, this.startY, x, y) : ((t = ((x - (float)this.startX) * (float)(this.endX - this.startX) + (y - (float)this.startY) * (float)(this.endY - this.startY)) / length) < 0.0f ? this.distance2(x, y, this.startX, this.startY) : (t > 1.0f ? this.distance2(x, y, this.endX, this.endY) : this.distance2(x, y, (float)this.startX + t * (float)(this.endX - this.startX), (float)this.startY + t * (float)(this.endY - this.startY))));
        return d;
    }

    private float distance2(float x1, float y1, float x2, float y2) {
        return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
    }
}

